/***************************************************************************
*
* Copyright 2010,2011 BMW Car IT GmbH
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/

#ifndef _GETINPUTDEVICECAPABILITIESCOMMAND_H_
#define _GETINPUTDEVICECAPABILITIESCOMMAND_H_

#include "ICommand.h"
#include "ilm_types.h"

class GetInputDeviceCapabilitiesCommand : public ICommand
{
public:
	GetInputDeviceCapabilitiesCommand(pid_t sender, t_ilm_string seat_name, ilmInputDevice* bitmask)
    : ICommand(ExecuteSynchronous, sender)
    , m_pBitmask(bitmask)
    , m_pSeatName(seat_name)
    {}

    /**
     * \brief default destructor
     */
    virtual ~GetInputDeviceCapabilitiesCommand() {}

    /**
     * \brief Execute this command.
     * \param[in] executor Pointer to instance executing the LayerManagement COmmands
     * \return ExecutionSuccess: execution successful
     * \return ExecutionSuccessRedraw: execution successful and screen needs to be redrawn
     * \return ExecutionFailed: execution failed
     * \return ExecutionFailedRedraw: execution unsuccessful and screen needs to be redrawn
     */
    virtual ExecutionResult execute(ICommandExecutor* executor);

    /**
     * \brief Get description string for this command.
     * \return String object with description of this command object
     */
    virtual const std::string getString();

private:
    ilmInputDevice *m_pBitmask;
    t_ilm_string  m_pSeatName;
};

#endif /* _GETINPUTDEVICECAPABILITIESCOMMAND_H_ */
